;; #############################################################################
;; # ========================================================================= #
;; # Bot IRC Syd - syd-quote-server-configuration.ss                           #
;; # Copyright (C) Lozi Jean-Pierre, 2007 - mailto:jean-pierre@lozi.org        #
;; # ========================================================================= #
;; #                                                                           #
;; # This program is free software; you can redistribute it and/or modify it   #
;; # under the terms of the GNU General Public License as published by the     #
;; # Free Software Foundation; either version 2 of the License, or (at your    #
;; # option) any later version.                                                #
;; #                                                                           #
;; # This program is distributed in the hope that it will be useful, but WITH- #
;; # OUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or # 
;; # FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for #
;; # for more details.                                                         #
;; #                                                                           #
;; # You should have received a copy of the GNU General Public License along   #
;; # with this program; if not, write to the Free Software Foundation, Inc.,   #
;; # 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.                 #
;; #                                                                           #
;; #############################################################################

;;
;; Taille des plus grands mots ignorés pour la recherche de citations.
;;
(define ignored-word-size-limit 4)

;;
;; Nombre minimum de mots considérés lors de la recherche de citations en rapport avec la phrase courante.
;;
(define minimum-number-of-considered-words 1) 

;;
;; Nombre maximum de mots considérés lors de la recherche de citations en rapport avec la phrase courante.
;;
(define maximum-number-of-considered-words 3)

;;
;; Tous les mots doivent-ils être trouvés dans l'expression, ou seulement l'un d'entre eux?
;;
(define match-all-words #t)

;;
;; Doit-on abandonner s'il y a moins de mots acceptables que le nombre minimum de mots voulus (surtout utile si 
;; match-all-words vaut #t)
;;
(define give-up-if-less-words-than-minimum-number-of-considered-words #f)

;;
;; Doit-on abandonner si on a moins de mots acceptables dans la phrase que le nombre de mots tirés au sort (même remarque)?
;;
(define give-up-if-less-words-than-number-of-considered-words #f)