;; #############################################################################
;; # ========================================================================= #
;; # Bot IRC Syd - syd-configuration.ss                                        #
;; # Copyright (C) Lozi Jean-Pierre, 2007 - mailto:jean-pierre@lozi.org        #
;; # ========================================================================= #
;; #                                                                           #
;; # This program is free software; you can redistribute it and/or modify it   #
;; # under the terms of the GNU General Public License as published by the     #
;; # Free Software Foundation; either version 2 of the License, or (at your    #
;; # option) any later version.                                                #
;; #                                                                           #
;; # This program is distributed in the hope that it will be useful, but WITH- #
;; # OUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or # 
;; # FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for #
;; # for more details.                                                         #
;; #                                                                           #
;; # You should have received a copy of the GNU General Public License along   #
;; # with this program; if not, write to the Free Software Foundation, Inc.,   #
;; # 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.                 #
;; #                                                                           #
;; #############################################################################

;;
;; Si cette fonction est activée, les échanges de messages entre le bot et le serveur sont affichés.
;;
(define display-messages #t)

;;
;; On initialise les paramètres à leurs valeurs par défaut.
;;
(define service-port 6667)
(define server-host "irc.rezel.net")
(define channel "#sydtest")
(define nickname "syd")
(define alternate-nickname "sydb")
(define login "syd")
(define first-name "Syd")
(define last-name "Barett")
(define connection-message "See you on the dark side of the moon")
(define encoding "ISO-8859-15")

;;
;; Plus ce taux est élevé, plus le bot est bavard.
;;
(define verbosity-ratio 0.9)

;;
;; Nombre par défaut de pseudonymes affichés lors d'un !hl.
;;
(define default-number-of-nicknames-on-hl 3)

;;
;; Nombre d'utilisateurs récents en mémoire.
;;
(define default-number-of-recent-users 3)

;;
;; Liste de messages (à un paramètre) à envoyer lorsque quelqu'un rejoint le canal.
;;
(define messages-1/someone-joins-the-channel
  '((good . ("Hello, ### !" "Salut, ### !" "Hey, ### !" "Coucou, ### !" "Bonjour, ### !" "Yop, ### !" "### \\o/"))
    (bad . ("Pff, ###..." "Tiens tiens, ###..." "### -_-" "Tu fais quoi ici, ###..." "Je rêve, ###..." "Oh non, pas lui."))))
                          

;;
;; Liste de messages (à un paramètre) à envoyer lorsque quelqu'un rejoint le canal une nouvelle fois.
;;
(define messages-1/someone-joins-the-channel-again
  '((good .("Re, ### !" "Tiens, ###, ça faisait longtemps !" "Encore toi, ### ?"
                       "Tiens, ###, je pensais que tu ne reviendrais plus !" "Tu m'as manqué, ### !"))
    (bad . ("Oh non, encore ###..." "Tu pourrais pas disparaître, ###?" "Encore toi, ### ?"
                                    "T'as rien d'autre à faire, ### ?"))))
    

;;
;; Liste de messages (à un paramètre) à envoyer lorsque quelqu'un quitte le canal.
;;
(define messages-1/someone-leaves
  '((good . ("Oh, ### est parti :(" "### va me manquer :/" "### ? T'es où? :'(" "Reviens, ### !" "Dites à ### de revenir :("
                           "Tu me manques déjà, ### :/"))
    (bad . ("Bon débarras, ### est parti." "Enfin débarassé de ###." "### ne va pas me manquer."
                                           "Vous pouvez pas faire comme ###, c'est-à-dire, partir ?"))))

;;
;; Liste de messages (à un paramètre) à envoyer quand on se fait kicker.
;;
(define messages-1/i-am-kicked
  '((good . ("Pourquoi tu m'as fait ça, ### ? :'(" "Méchant, ### ! :'(" "Un jour, j'te kickerai, ### ! :("
                                         "Kicker, c'est pas très sympa, ### ! :("))
    (bad . ("Tu me paieras ça, ###..." "###, espèce d'enfoiré !" "### je te hais je te hais je te hais"
                                       "###, sale impoli de nazi de m**** !"))))

;;
;; Liste de messages (à un paramètre) à envoyer quand quelqu'un se fait kicker.
;;
(define messages-1/someone-is-kicked
  '((good .("Pauve ### :/" "Oh, ### a été kické :(" "Pourquoi vous avez kické ### ? :'(" "Oh, pauvre ### :/" "### :'("))
    (bad . ("Hahaha, ca te fera les pieds, ### !" "Tieeeeens, ###!" "Prends ça, ###!"))))

;;
;; Liste de messages (à un paramètre) à envoyer quand quelqu'un envoie un "o<".
;;
(define messages-1/someone-tells-me-o<
  '((good . ("### : o<" "### : \\_O<" "### : \\_O< \\_o< \\_O<" "### : coin!" "### : 0<"))
    (bad . ("### : pan!" "### : pan! pan! pan! Crève, sale canard!" "J'aime pas les canards, ###."))))

;;
;; Liste de messages (sans paramètre) à envoyer lorsqu'on part du canal.
;;
(define messages-0/i-leave
  '("Bonjour, je suis un message-virus. Utilisez-moi comme message de sortie pour que je puisse dominer irc!"
    "Money, get away! Get a good job with good pay and youre okay!"
    "I'm not here... This isn't happening."
    "Je pars, vois-tu, je sais que tu m'attends."
    "J'vous déteste tous!"
    "Ciao les gens :'("
    "Hasta la vista, baby!"))
