/*****************************************************************************/
/* ========================================================================= */
/*  types.h                                                                  */
/*  Contains the global type defintions.                                     */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*****************************************************************************/
/* OpenGL headers                                                            */
/*****************************************************************************/
#include <GL/gl.h>
#include <GL/glu.h>

#ifndef TYPES_H
#define TYPES_H

/*****************************************************************************/
/* Type definitions                                                          */
/*****************************************************************************/

/*
 * A Vector a simple 3D vector.
 */
typedef GLfloat Vector[3];
typedef GLfloat Color[3];

/*
 * A LandscapePoint is a point in the landscape grid, it has a position,
 * two normals, and a height.
 */
typedef struct {
    Vector position;
    Vector top_left_normal, bottom_right_normal;
    Vector top_left_smooth_normal, bottom_right_smooth_normal;
    Color color;
}
LandscapePoint, **Landscape;

#endif
