/*****************************************************************************/
/* ========================================================================= */
/*  tools.h                                                                  */
/*  The tools module contains miscellaneous functions.                       */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TOOLS_H
#define TOOLS_H

/*****************************************************************************/
/* Local headers                                                             */
/*****************************************************************************/
#include "types.h"

/*****************************************************************************/
/* Function prototypes                                                       */
/*****************************************************************************/

/*
 * Allocates a block of memory of the given size.
 */
extern void
*allocate( int size );

/*
 * Returns a random number with a centered normal distribution of the given
 * variance.
 */
extern float
gauss_random( float variance );

/*
* This simple function computes the vectorial product of two vectors.
*/
extern void
cross_product( Vector u, Vector v, Vector result );

/*
 * This simple function returns the difference between two vectors.
 */
extern void
difference( Vector a, Vector b, Vector result );

#endif
