/*****************************************************************************/
/* ========================================================================= */
/*  rendering.h                                                              */
/*  The rendering module contains the rendering/3D functions.                */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef RENDERING_H
#define RENDERING_H

/*****************************************************************************/
/* Function Prototypes                                                       */
/*****************************************************************************/
/*
 * This function initializes the parameters of our OpenGL window.
 */
extern void
init_gl( int width, int height );

/*
 * This function computes the landscape's properties.
 */
extern void
draw_gl_scene( void );

/*
 * This function frees the current landscape.
 */
extern void
resize_gl_scene( int width, int height );

#endif
