/*****************************************************************************/
/* ========================================================================= */
/*  main.c                                                                   */
/*  Where the application starts.                                            */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*****************************************************************************/
/* Gtk+/GtkGLExt headers                                                     */
/*****************************************************************************/
#include <gtk/gtk.h>
#include <gtk/gtkgl.h>

/*****************************************************************************/
/* Standard headers                                                          */
/*****************************************************************************/
#include <stdlib.h>
#include <time.h>

/*****************************************************************************/
/* Local headers                                                             */
/*****************************************************************************/
#include "constants.h"
#include "globals.h"
#include "generation.h"
#include "gui.h"

/*****************************************************************************/
/* Functions                                                                 */
/*****************************************************************************/

/*
 * The main function - the command line arguments are directly passed to GTK+.
 */
int
main( int argc, char **argv ) {
    /* We initialize the pseudo-random numbers generator - so that the landscape
     * that we generate is *really* randomized. */
    srand( ( unsigned int )time( NULL ) );

    init_global_variables();

    /* We initialize the i18n support. */
    gtk_set_locale();

    /* We initialize GTK+... */
    gtk_init( &argc, &argv );

    /* ...GTKGL... */
    gtk_gl_init( &argc, &argv );

    /* ...and OpenGL. */
    init_gl( WINDOW_INITIAL_WIDTH, WINDOW_INITIAL_HEIGHT );

    /* We create the main window. */
    create_main_window( WINDOW_INITIAL_WIDTH, WINDOW_INITIAL_HEIGHT );

    /* We generate the landscape. */
    if( display_new_landscape_dialog() )
        display_properties_dialog();

    /* We enter the main event loop, and wait for user interaction. */
    gtk_main ();

    /* The user lost interest. */
    return EXIT_SUCCESS;
}
