/*****************************************************************************/
/* ========================================================================= */
/*  gui.h                                                                    */
/*  The GUI module contains the user interface related functions.            */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GUI_H
#define GUI_H

/*****************************************************************************/
/* Local headers                                                             */
/*****************************************************************************/
#include "rendering.h"
#include "tools.h"

/*****************************************************************************/
/* Function prototypes                                                       */
/*****************************************************************************/

/*
 * This function displays the "New Landscape..." dialog.
 */
extern int
display_new_landscape_dialog( void );

/*
* This function displays the "Properties..." dialog.
*/
extern int
display_properties_dialog( void );

/*
 * This function creates the main window, with all its components.
 */
extern void
create_main_window( float width, float height );

#endif
