/*****************************************************************************/
/* ========================================================================= */
/*  globals.c                                                                */
/*  Contains the global variables.                                           */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GLOBALS_H
#define GLOBALS_H

/*****************************************************************************/
/* Local headers                                                             */
/*****************************************************************************/
#include "constants.h"
#include "types.h"

/*****************************************************************************/
/* OpenGL headers                                                            */
/*****************************************************************************/
#include <GL/gl.h>

/*****************************************************************************/
/* Global variables                                                          */
/*****************************************************************************/

/* Rendering globals. */
extern float g_water_level;
extern float g_perspective;
extern float g_fog_start;
extern float g_fog_end;
extern float g_initial_variance;
extern float g_rotation_step;
extern float g_water_level_step;
extern float g_attenuation_factor;
extern float g_landscape_size;
extern float g_fog_density;
extern float g_water_precision;
extern float g_perspective;
extern float g_water_step;
extern float g_ground_precision;
extern float g_water_opacity;
extern float g_ground_luminosity;
extern float g_field_of_view_angle;
extern float g_motion_step;
extern float g_color_variance;
extern long g_water_pos_counter;
extern int g_ground;
extern int g_reflection;
extern int g_smooth_normals;
extern int g_filtered_textures;
extern int g_fog;
extern int g_animate;
extern int g_textures;
extern int g_num_recursions;
extern int g_load_textures;
extern GLfloat g_sky_color[];
extern GLfloat g_light_ambient_color[];
extern GLfloat g_light_diffuse_color[];
extern Vector g_light_position;
extern Vector g_position;
extern Color g_colors_array[];
extern char g_water_texture_path[];
extern char g_landscape_texture_path[];
extern char g_current_file_path[];

/* These variables store the camera's position. */
extern float g_theta;
extern float g_phi;
extern float g_x_position;
extern float g_y_position;
extern float g_z_position;

/* These variables are used to store the landscape and the number of divisions
   per side it has. */
extern Landscape g_landscape;
extern long g_num_divisions;

/*****************************************************************************/
/* Function prototypes                                                       */
/*****************************************************************************/
extern void
init_global_variables( void );

#endif
