/*****************************************************************************/
/* ========================================================================= */
/*  globals.c                                                                */
/*  Contains the global variables.                                           */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*****************************************************************************/
/* Local headers                                                             */
/*****************************************************************************/
#include "constants.h"
#include "types.h"
#include "tools.h"

/*****************************************************************************/
/* OpenGL headers                                                            */
/*****************************************************************************/
#include <GL/gl.h>
#include <glib.h>
#include <string.h>
#include <stdio.h>
/*****************************************************************************/
/* Global variables                                                          */
/*****************************************************************************/

/* Rendering globals. */
float g_water_level = 200.0f;
float g_fog_start = 5000.0f;
float g_fog_end = 20000.0f;
float g_initial_variance = 1800.0f;
float g_rotation_step = 1.0f;
float g_water_level_step = 10.0f;
float g_water_step = .007f;
float g_landscape_size = 12000.0f;
float g_attenuation_factor = 2.3f;
float g_fog_density = 0.35f;
float g_water_precision = 200.0f;
float g_water_opacity = .8f;
float g_perspective = 40000.0f;
float g_ground_precision = 1000.0f;
float g_field_of_view_angle = 25.0f;
float g_motion_step = 25.0f;
float g_color_variance = 75.0f;
long g_water_pos_counter = 0;
int g_reflection = 0;
int g_ground = 1;
int g_smooth_normals = 1;
int g_filtered_textures = 1;
int g_melted_colors = 1;
int g_fog = 1;
int g_animate = 1;
int g_textures = 1;
int g_load_textures = 1;
int g_num_recursions = 8;
GLfloat g_sky_color[] = { 0.6f, 0.8f, 1.0f, 1.0f };
GLfloat g_light_ambient_color[]= { .3f, .3f, .5f, 1.0f };
GLfloat g_light_diffuse_color[]= { .8f, .8f, .8f, 1.f };
Vector g_light_position = { 2000.0f, -2000.0f, 100.0f };
Color g_colors_array[NUM_LEVELS] = { { 1.f, 1.f, .6f },
                                     { .4, .58f, .19f },
                                     { .49f, .44f, .34f },
                                     { .64f, .64f, .46f },
                                     { 1.f, 1.f, 1.f },
                                     { 1.f, 1.f, 1.f } };
Vector g_position = { -10000.0f, 10000.0f, 1000.0f };

/* Textures */
char g_water_texture_path[FILE_NAME_SIZE];
char g_landscape_texture_path[FILE_NAME_SIZE];
char g_current_file_path[FILE_NAME_SIZE] = "";

/* These variables store the camera's position. */
float g_theta = 40.0f;
float g_phi = 0.0f;

/* These variables are used to store the landscape and the number of divisions
   per side it has. */
Landscape g_landscape = NULL;
long g_num_divisions;

/*****************************************************************************/
/* Functions                                                                 */
/*****************************************************************************/

/*
 * This function initializes the global variables.
 */
void
init_global_variables( void ) {
    char *path, *water_file_name, *landscape_file_name;

    path = g_get_current_dir();

    water_file_name = g_build_filename( path, "textures", "water.bmp", NULL );
    landscape_file_name = g_build_filename( path, "textures", "terrain.bmp", NULL );

    strcpy( g_water_texture_path, water_file_name );
    strcpy( g_landscape_texture_path, landscape_file_name );

    g_free( path );
    g_free( water_file_name );
    g_free( landscape_file_name );
}
