/*****************************************************************************/
/* ========================================================================= */
/*  generation.h                                                             */
/*  The GUI module contains the user interface related functions.            */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef GENERATION_H
#define GENERATION_H

/*****************************************************************************/
/* Local headers                                                             */
/*****************************************************************************/
#include "tools.h"
#include "types.h"

/*****************************************************************************/
/* Function prototypes                                                       */
/*****************************************************************************/

/*
 * This function generates the landscape using a fractal algorithm.
 */
extern Landscape
generate_landscape( float attenuation_factor, int recursions, float variance,
                    float landscape_size, long *num_divisions, Color colors_array[] );

/*
 * This function frees the current landscape.
 */
extern void
free_landscape( Landscape landscape, int landscape_size );

/*
 * This function computes the landscape's properties.
 */
extern void
compute_landscape_properties( int compute_colors, Landscape landscape, int num_divisions,
                              float cell_size, int landscape_size,
                              float min_height, float max_height,
                              Color colors_array[] );

#endif
