/*****************************************************************************/
/* ========================================================================= */
/*  constants.h                                                              */
/*  This file contains the symbolic constants.                               */
/* ========================================================================= */
/*  GenesX - A 3D fractal mountains generator                                */
/*  Copyright (C) Jean-Pierre Lozi, 2005                                     */
/* ========================================================================= */
/*****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*****************************************************************************/
/* Symbolic Constants                                                        */
/*****************************************************************************/
#define NUM_LEVELS              6
#define NUM_TEXTURES            2
#define FILE_NAME_SIZE          1024
#define PI_OVER_180             .0174532925
#define WINDOW_INITIAL_WIDTH    640
#define WINDOW_INITIAL_HEIGHT   480
#define MIN_RECURSIONS          2
#define MAX_RECURSIONS          30
#define BIG_STEP                1000.0f
#define LARGE_STEP              100.0f
#define NORMAL_STEP             1.0f
#define LITTLE_STEP             .1f
#define MAXFLOAT                ( ( float )3.40282346638528860e+38 )
#define MINFLOAT                ( ( float )10e-6 )
