package org.lozi.ajp.ajp;

/**
 * AjpUserSurface abstract class.
 * The user should derive this class each time he needs to plot a  a R -> R2 function.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public abstract class AjpUserSurface {
	/** The x lower bound. */
	protected double xLowerBound;
	/** The x upper bound. */
	protected double xUpperBound;
	/** The y lower bound. */
	protected double yLowerBound;
	/** The y upper bound. */
	protected double yUpperBound;
	/** The grid's size. */
	protected double gridSize;
	/** The plot's color. */
	protected String colorString;
	
	/**
	 * Evaluates the curve's function at the (x,y) position.
	 * 
	 * @param t The parameter for which the function should be evaluated.
	 * @return The evaluation.
	 */
	public abstract double evaluate( double x, double y );

	/**
	 * Initializes the local variables.
	 */
	public abstract void init ();

	/**
	 * @return Returns the color string.
	 */
	public String getColorString() {
		return colorString;
	}

	/**
	 * @return Returns the xLowerBound.
	 */
	public double getXLowerBound() {
		return xLowerBound;
	}

	/**
	 * @return Returns the xUpperBound.
	 */
	public double getXUpperBound() {
		return xUpperBound;
	}

	/**
	 * @return Returns the yLowerBound.
	 */
	public double getYLowerBound() {
		return yLowerBound;
	}

	/**
	 * @return Returns the yUpperBound.
	 */
	public double getYUpperBound() {
		return yUpperBound;
	}

	/**
	 * @return Returns the gridSize.
	 */
	public double getGridSize() {
		return gridSize;
	}

}