package org.lozi.ajp.ajp;

import javax.swing.JFrame;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawableFactory;

/**
 * AjpUserPlotterTools class. An instance of this class is passed to the functions of
 * the the scripts. All the actions the user can do come from this class.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 * @version 1.0
 */
public class AjpUserPlotter {

	/**
	 * Creates a new window.
	 * 
	 * @param title The window title.
	 * @param width The window width.
	 * @param height The window height.
	 * @param x The window x position.
	 * @param y The window y position.
	 * @param lightsArray The array containing the window's lights (8 max).
	 * @return The newly created window.
	 */
	public AjpUserWindow newWindow( String title, int width, int height, int x, int y, AjpUserLight[] lightsArray ) {
		// We create the new window itself.
		JFrame window = new JFrame( title );
		// We create a GLCapabilities object.
		GLCapabilities capabilities = new GLCapabilities(); 
		// We create the GLCanvas.
		GLCanvas context = GLDrawableFactory.getFactory().createGLCanvas(capabilities);
		// We add the context to the window.
		window.getContentPane().add(context);
		// We set the window position.
		window.setLocation( x, y );
		// We set the window size.
		window.setSize( width, height ); 
		// We create the event listener.
		AjpGLEventListener listener = new AjpGLEventListener( lightsArray );
		// We add a new event listener to the window.
		context.addGLEventListener( listener );
		// We show the window.
		window.setVisible( true );
		// And we return the corresponding AjpUserWindow
		return new AjpUserWindow( window, listener, context );
	}

}