package org.lozi.ajp.ajp;

/**
 * AjpUserParameteredSurface interface.
 * The user should derive this class each time he needs a new curve with a two parameters.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public abstract class AjpUserParameteredSurface {
	/** The lower bound for the parameter t. */
	protected double tLowerBound;
	/** The upper bound for the parameter t. */
	protected double tUpperBound;
	/** The lower bound for the parameter s. */
	protected double sLowerBound;
	/** The upper bound for the parameter s. */
	protected double sUpperBound;
	/** The step for the s parameter. */
	protected float sStep;
	/** The step for the t parameter. */
	protected float tStep;
	/** The plot's color. */
	protected String colorString;
	
	/**
	 * Evaluates the function for the parameters s and t.
	 * Should return a tridimensionnal array of double values.
	 * 
	 * @param s The first parameter for which the function should be evaluated.
	 * @param t The scond parameter for which the function should be evaluated.
	 * @return The evaluated point.
	 */
	public abstract AjpUser3DPoint evaluate( double s, double t );
	
	/**
	 * Initializes the local variables.
	 */
	public abstract void init ();

	/**
	 * @return Returns the sLowerBound.
	 */
	public double getSLowerBound() {
		return sLowerBound;
	}

	/**
	 * @return Returns the sUpperBound.
	 */
	public double getSUpperBound() {
		return sUpperBound;
	}

	/**
	 * @return Returns the tLowerBound.
	 */
	public double getTLowerBound() {
		return tLowerBound;
	}

	/**
	 * @return Returns the tUpperBound.
	 */
	public double getTUpperBound() {
		return tUpperBound;
	}

	/**
	 * @return Returns the sStep.
	 */
	public float getSStep() {
		return sStep;
	}

	/**
	 * @return Returns the tStep.
	 */
	public float getTStep() {
		return tStep;
	}

	/**
	 * @return Returns the colorString.
	 */
	public String getColorString() {
		return colorString;
	}

}