package org.lozi.ajp.ajp;

/**
 * AjpUserParameteredCurve abstract class.
 * The user should derive this class each time he needs a new curve with a single paramater.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public abstract class AjpUserParameteredCurve {
	/** The lower bound for the parameter t. */
	protected double tLowerBound;
	/** The upper bound for the parameter t. */
	protected double tUpperBound;
	/** The plot color. */
	protected AjpUserColor color;
	/** The line width. */
	protected float lineWidth;
	/** The step. */
	protected double step;
	
	/**
	 * Evaluates the function for the parameter t.
	 * Should return a point, the value of the function at t.
	 * 
	 * @param t The parameter for which the function should be evaluated.
	 */
	public abstract AjpUser3DPoint evaluate( double t );

	/**
	 * Initializes the local variables.
	 */
	public abstract void init ();
	
	/**
	 * @return Returns the color.
	 */
	public AjpUserColor getColor() {
		return color;
	}

	/**
	 * @return Returns the tLowerBound.
	 */
	public double getTLowerBound() {
		return tLowerBound;
	}

	/**
	 * @return Returns the tUpperBound.
	 */
	public double getTUpperBound() {
		return tUpperBound;
	}

	/**
	 * @return Returns the lineWidth.
	 */
	public float getLineWidth() {
		return lineWidth;
	}

	/**
	 * @return Returns the step.
	 */
	public double getStep() {
		return step;
	}
}