package org.lozi.ajp.ajp;

/**
 * This class represents a simple light.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public class AjpUserLight {
	/** The light position. */
	public AjpUser3DPoint position;
	/** The light color. */
	public AjpUserColor color;
	
	/**
	 * Creates an AjpUserLight.
	 * 
	 * @param position The light position.
	 * @param color The light color.
	 */
	public AjpUserLight ( AjpUser3DPoint position, AjpUserColor color ) {
		this.position = position;
		this.color = color;
	}

	/**
	 * @return Returns the color.
	 */
	public AjpUserColor getColor() {
		return color;
	}

	/**
	 * @return Returns the position.
	 */
	public AjpUser3DPoint getPosition() {
		return position;
	}

	/**
	 * @param color The color to set.
	 */
	public void setColor(AjpUserColor color) {
		this.color = color;
	}
	
	/**
	 * @param position The position to set.
	 */
	public void setPosition(AjpUser3DPoint position) {
		this.position = position;
	}
}