package org.lozi.ajp.ajp;

/**
 * AjpUserParameteredCurve abstract class.
 * The user should derive this class each time he needs a new curve with a single paramater.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public abstract class AjpUserDot {
	/** The plot's coordinates. */
	protected AjpUser3DPoint coordinates;
	/** The plot color. */
	protected AjpUserColor color;
	/**
	 * Initializes the local variables.
	 */
	public abstract void init ();
	
	/**
	 * @return Returns the color.
	 */
	public AjpUserColor getColor() {
		return color;
	}

	/**
	 * @return Returns the coordinates.
	 */
	public AjpUser3DPoint getCoordinates() {
		return coordinates;
	}
}