package org.lozi.ajp.ajp;

/**
 * This class represents a color with its alpha channel.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public class AjpUserColor
{
	/** The amount of red in the color. Between 0.0 and 1.0. */ 
	private float red;
	/** The amount of green in the color. Between 0.0 and 1.0. */ 
	private float green;
	/** The amount of blue in the color. Between 0.0 and 1.0. */ 
	private float blue;
	/** The color's alpha channel. Between 0.0 and 1.0. */
	private float alpha;
	
	/**
	 * Creates an AjpUserColor object.
	 * 
	 * @param red The amount of red. Between 0.0 and 1.0.
	 * @param green The amount of green. Between 0.0 and 1.0.
	 * @param blue The amount of blue. Between 0.0 and 1.0.
	 * @param alpha The alpha channel. Between 0.0 and 1.0.
	 */
	public AjpUserColor( float red, float green, float blue, float alpha ) {
		this.red = red;
		this.green = green;
		this.blue = blue;
		this.alpha = alpha;
	}


	/**
	 * @return Returns the amount of red.  Between 0.0 and 1.0.
	 */
	public float getRed() {
		return red;
	}
	
	/**
	 * @return Returns the amount of green. Between 0.0 and 1.0.
	 */
	public float getGreen() {
		return green;
	}
	
	/**
	 * @return Returns the amount of blue. Between 0.0 and 1.0.
	 */
	public float getBlue() {
		return blue;
	}
	
	/**
	 * @return Returns the alpha channel's value. Between 0.0 and 1.0.
	 */
	public float getAlpha() {
		return alpha;
	}

	/**
	 * @param red The amount of red to set. Between 0.0 and 1.0.
	 */
	public void setRed(float red) {
		this.red = red;
	}
	
	/**
	 * @param green The amount of green to set. Between 0.0 and 1.0.
	 */
	public void setGreen(float green) {
		this.green = green;
	}
	
	/**
	 * @param blue The amount of blue to set. Between 0.0 and 1.0.
	 */
	public void setBlue(float blue) {
		this.blue = blue;
	}
	
	/**
	 * @param alpha The alpha channel to set. Between 0.0 and 1.0.
	 */
	public void setAlpha(float alpha) {
		this.alpha = alpha;
	}
}