package org.lozi.ajp.ajp;

/**
 * This class represents a 3D point with its alpha channel.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public class AjpUser3DPoint
{
	/** The x coordinate. */
	private double x;
	/** The y coordinate. */
	private double y;
	/** The z coordinate. */
	private double z;
	
	/**
	 * Creates a new 3D point.
	 * 
	 * @param x The x coordinate.
	 * @param y The y coordinate.
	 * @param z The z coordinate.
	 */
	public AjpUser3DPoint( double x, double y, double z ) {
		this.x = x;
		this.y = y;
		this.z = z;
	}

	/**
	 * @return Returns the x coordinate.
	 */
	public double getX() {
		return x;
	}

	/**
	 * @return Returns the y coordinate.
	 */
	public double getY() {
		return y;
	}

	/**
	 * @return Returns the z coordinate.
	 */
	public double getZ() {
		return z;
	}

	/**
	 * @param x The x coordinate to set.
	 */
	public void setX(double x) {
		this.x = x;
	}

	/**
	 * @param y The y coordinate to set.
	 */
	public void setY(double y) {
		this.y = y;
	}

	/**
	 * @param z The z coordinate to set.
	 */
	public void setZ(double z) {
		this.z = z;
	}
}