package org.lozi.ajp.ajp.scripts;

import org.lozi.ajp.ajp.*;


/**
 * This example plots points on two virtual surfaces.
 * 
 * @author Jean-Pierre Lozi - mailto:jean-pierre@lozi.org
 */
public class Example4 implements AjpUserScript
{
	public void start( AjpUserPlotter plotter ) {
		// We create the lights.
		AjpUserLight[] lights = new AjpUserLight[] {
				new AjpUserLight(	new AjpUser3DPoint( 0, 0, 5 ),
									new AjpUserColor( .5f, .5f, .5f, 1f ) ) };
		
		// We create the window.
		AjpUserWindow window = plotter.newWindow( "First test window", 320, 240, 10, 10, lights );
		// We set the background color.
		window.setBackgroundColor( new AjpUserColor( .0f, .0f, .0f, 1.0f) );
		// We set the axes' bounds and colors.
		window.setAxesBounds( -12, 12, -12, 12, -12, 12 );
		window.setAxesColor( new AjpUserColor( 1f, .5f, 0f, 1.0f) );
		// Ok now we create the thread which plots the points
		FirstComputation firstComputation = new FirstComputation ( window );
		firstComputation.start();
		
		// The second plotting is made with an action.
		window.setAction( new SecondComputation() );
		
		window.setRotationSteps( 0.1, 0.0 );
		window.animate();
	}
	
	/**
	 * The first computation, which uses a thread.
	 */
	public class FirstComputation extends Thread {
		/** The window to which this thread is bound. */
		private AjpUserWindow window;
		
		/**
		 * The Calculus constructor
		 * 
		 * @param window The window to which the calculus is bound.
		 */
		public FirstComputation ( AjpUserWindow window ) {
			this.window = window;
		}
		
		/**
		 * The computation itself.
		 */
		public void run() {
				/*
				 * Now we plot. The calculus is really easy - just incrementing y or z at each iteration.
				 * However it could easily be replaced by any calculus. We sleep between each point to simulate
				 * the time taken by the computation.
				 */
				for( double y = -10.0 ; y <= 10.0 ; y += 1.0 ) {
					for( double z = -10.0 ; z <= 10.0 ; z += 1.0 ) {
						final double dotY = y;
						final double dotZ = z;
						
						window.addDot( new AjpUserDot() {
							public void init() {
								this.color = new AjpUserColor( 0.0f , 1.0f , 0.0f, 1.0f );
								this.coordinates = new AjpUser3DPoint( 0, dotY, dotZ);
							}
						});
						
						// Now we take a nap :) (There should be the *real* computation here... Or before adding the dot.)
						try {
							Thread.sleep( 1250L );
							Thread.yield();
						}
						catch( Exception e ) {}
						
						}
				}
		}
	}
	
	/**
	 * The second computation, which uses an action.
	 */
	public class SecondComputation implements AjpUserWindowAction {
		private double currentX = -10;
		private double currentY = -10;
		
		/**
		 * The computation itself.
		 */
		public void run( AjpUserWindow window ) {
			
			final double dotX = currentX;
			final double dotY = currentY;
			
			if( currentY > 10 ) return;
			
			window.addDot( new AjpUserDot() {
				public void init() {
					this.color = new AjpUserColor( 1f , 1f , 1f, 1.0f );
					this.coordinates = new AjpUser3DPoint( dotX, dotY, 0 );
				}	
			});
			
			if( currentX < 10 ) currentX += 0.25;
			else {
				currentX = -10;
				currentY += 0.25;
			}
		}
		
	}
}