package org.lozi.ajp.ajp.scripts;

import org.lozi.ajp.ajp.*;

public class Example3 implements AjpUserScript
{
	public void start( AjpUserPlotter plotter ) {
		// We create the lights.
		AjpUserLight[] lights = new AjpUserLight[] {
				new AjpUserLight(	new AjpUser3DPoint( 0, 0, 5 ),
									new AjpUserColor( .5f, .5f, .5f, 1f ) ) };
		
		// We create the window.
		AjpUserWindow window = plotter.newWindow( "First test window", 320, 240, 10, 10, lights );
		// We set the background color.
		window.setBackgroundColor( new AjpUserColor( 0.1f, 0.1f, 0.1f, 1.0f) );
		
		// We add the parametered surface.
		window.addParameteredSurface( new AjpUserParameteredSurface() {
			public AjpUser3DPoint evaluate( double s, double t ) {
				return new AjpUser3DPoint( s, t, s*s );
			}

			
			public void init() {
				this.colorString = "Purple";
				this.sLowerBound = -10;
				this.sUpperBound = 10;
				this.tLowerBound = -10;
				this.tUpperBound = 10;
				this.sStep = 0.3f;
				this.tStep = 0.6f;
			}
		});
		
		window.setRotationSteps( 0.1, 0.0 );
		window.animate();
	}
}