package org.lozi.ajp.ajp.scripts;

import org.lozi.ajp.ajp.*;

import java.util.ArrayList;

public class Example2 implements AjpUserScript
{		
	public void start( AjpUserPlotter plotter ) {
		// We create the lights.
		AjpUserLight[] lights = new AjpUserLight[] {
				new AjpUserLight(	new AjpUser3DPoint( 0, 0, 5 ),
									new AjpUserColor( .5f, .5f, .5f, 1f ) ) };
		
		// We create the window.
		AjpUserWindow window = plotter.newWindow( "First test window", 320, 240, 10, 10, lights );
		// We set the background color.
		window.setBackgroundColor( new AjpUserColor( 0.1f, 0.1f, 0.1f, 1.0f) );
		// We add a surface to the window.
		window.addSurface( new MySurface() );
		// We add a parametered curve.
		window.addParameteredCurve( new MyParameteredCurve() );
		// We set the window's action.
		window.setAction( new AjpUserWindowAction() {
			public void run ( AjpUserWindow window ) {
				MySurface surface = (MySurface)window.getSurfacesArrayList().get( 0 );
				MyParameteredCurve curve = (MyParameteredCurve)window.getParameteredCurvesArrayList().get( 0 );
				// We increment the parameter T of the first surface.
				surface.setT( surface.getT() + 0.1 );
				curve.setU( curve.getU() + 0.01 );
			}
		});
		
		// We set the rotation steps.
		window.setRotationSteps( 0.1, 0 );
		// We set the axes' bounds.
		window.setAxesBounds( -20, 20, -20, 20, -20, 20 );
		// We animate the window.
		window.animate();
	}
	
	
	class MySurface extends AjpUserSurface {
		// We set a parameter that we can update.
		private double t;
		
		public double evaluate( double x, double y ) {
			return Math.cos( Math.sqrt( x * x + y * y ) + t );
		}
		
		public void init() {
			this.colorString = "Orange";
			this.xLowerBound = -15;
			this.xUpperBound = 15;
			this.yLowerBound = -15;
			this.yUpperBound = 15;
			this.gridSize = 0.3;
		}
		
		public double getT() {
			return t;
		}
		
		public void setT( double t ) {
			this.t = t;
		}
	}
	
	class MyParameteredCurve extends AjpUserParameteredCurve {
		// We set a second parameter.
		private double u;
		
		public AjpUser3DPoint evaluate( double t ) {
			double R=1.0;
			double r=0.2;
			double n=17.0/2;
			return new AjpUser3DPoint(  ( R + r * Math.cos( n * t + u )) * Math.cos( t + u ) * 15,
										( R + r * Math.cos( n * t + u ) ) * Math.sin( t + u) * 15,
										( r * Math.sin( n * t + u ) * 15 ) );
		}
		
		public void init() {
			this.color = new AjpUserColor( .9f, 0.8f, 0.9f, 1.0f );
			this.tLowerBound = -7;
			this.tUpperBound = 7;
			this.step = 0.01;
		}
		
		public double getU() {
			return u;
		}
		
		public void setU( double u ) {
			this.u = u;
		}	
	}
}