package org.lozi.ajp.ajp.scripts;

import org.lozi.ajp.ajp.*;

public class Example1 implements AjpUserScript
{
	public void start( AjpUserPlotter plotter ) {
		// We create the lights.
		AjpUserLight[] lights = new AjpUserLight[] {
				new AjpUserLight(	new AjpUser3DPoint( 0, 0, 5 ),
									new AjpUserColor( .5f, .5f, .5f, 1f ) ) };
		
		// We create the window.
		AjpUserWindow window = plotter.newWindow( "First test window", 320, 240, 10, 10, lights );
		// We set the background color.
		window.setBackgroundColor( new AjpUserColor( 0f, 0f, 0f, 1.0f) );
		
		// We add three surfaces.
		window.addSurface( new AjpUserSurface() {
			public double evaluate( double x, double y ) {
				return Math.cos( x ) + Math.cos( y );
			}

			
			public void init() {
				this.colorString = "Blue";
				this.xLowerBound = -10;
				this.xUpperBound = 10;
				this.yLowerBound = -10;
				this.yUpperBound = 10;
				this.gridSize = 0.3;
			}
		});
		
		window.addSurface( new AjpUserSurface() {
			public double evaluate( double x, double y ) {
				return Math.sin( x * y );
			}

			
			public void init () {
				this.colorString = "Red";
				this.xLowerBound = -5;
				this.xUpperBound = 5;
				this.yLowerBound = -5;
				this.yUpperBound = 5;
				this.gridSize = 0.1;
			}
		});
	
		window.addSurface( new AjpUserSurface() {
			public double evaluate( double x, double y ) {
				if( x * y > 0 )
					return Math.sqrt( x * y );
				else return Math.sqrt( - x * y );
			}

			
			public void init() {
				this.colorString = "Yellow";
				this.xLowerBound = -6;
				this.xUpperBound = 6;
				this.yLowerBound = -6;
				this.yUpperBound = 6;
				this.gridSize = 0.5;
			}
		});
		
		// We set the axes' bounds.
		window.setAxesBounds( -10.0, 10.0, -10.0, 10.0, -10.0, 10.0 );
		
		// We set the rotation steps.
		window.setRotationSteps( 0.1, 0.0 );
		
		// We animate the window.
		window.animate();
		
		// Now we create another window.
		// We create two lights.
		lights = new AjpUserLight[] {
				new AjpUserLight( new AjpUser3DPoint( 0, 0, 2 ),
				new AjpUserColor( .8f, .8f, .8f, 1f ) ) };
		
		// We create the window itself.
		window = plotter.newWindow( "Second test window", 320, 240, 400, 10, lights );
		
		// We set its background color.
		window.setBackgroundColor( new AjpUserColor( 0.1f, 0.1f, 0.2f, 1.0f) );
		
		// We add two surfaces and two parametered curves.
		window.addSurface( new AjpUserSurface() {
			public double evaluate( double x, double y ) {
				return Math.cos(x + y);
			}
			
			public void init() {
				this.colorString = "Purple";
				this.xLowerBound = -10;
				this.xUpperBound = 10;
				this.yLowerBound = -10;
				this.yUpperBound = 10;
				this.gridSize = 0.3;
			}
		});
		
		window.addSurface( new AjpUserSurface() {
			public double evaluate( double x, double y ) {
				return Math.cos( x - y );
			}
			
			public void init() {
				this.colorString = "Cyan";
				this.xLowerBound = -10;
				this.xUpperBound = 10;
				this.yLowerBound = -10;
				this.yUpperBound = 10;
				this.gridSize = 0.3;
			}
		});
		
		window.addParameteredCurve( new AjpUserParameteredCurve() {
			public AjpUser3DPoint evaluate( double t ) {
				double R=1.0;
				double r=0.2;
				double n=17.0/2;
				return new AjpUser3DPoint(  ( R + r * Math.cos( n * t )) * Math.cos( t ) * 15,
											( R + r * Math.cos( n * t ) ) * Math.sin( t ) * 15,
											( r * Math.sin( n * t ) * 15 ) );
			}
			
			public void init() {
				this.color = new AjpUserColor( .9f, 0.8f, 0.9f, 1.0f );
				this.tLowerBound = -7;
				this.tUpperBound = 7;
				this.step = 0.01;
			}
		});
		
		window.addParameteredCurve( new AjpUserParameteredCurve() {
			public AjpUser3DPoint evaluate( double t ) {
				double R=1.0;
				double r=0.2;
				double n=17.0/2;
				return new AjpUser3DPoint(  ( R + r * Math.cos( n * t + 0.2 )) * Math.cos( t + 0.2 ) * 15,
											( R + r * Math.cos( n * t + 0.2 ) ) * Math.sin( t + 0.2 ) * 15,
											( r * Math.sin( n * t + 0.2 ) * 15 ) );
			}
			
			public void init() {
				this.color = new AjpUserColor( .8f, .8f, .9f, 1.0f );
				this.tLowerBound = -7;
				this.tUpperBound = 7;
				this.step = 0.01;
			}
		});
		
		window.addParameteredCurve( new AjpUserParameteredCurve() {
			public AjpUser3DPoint evaluate( double t ) {
				double R=1.0;
				double r=0.2;
				double n=17.0/2;
				return new AjpUser3DPoint(  ( R + r * Math.cos( n * t + 0.4 )) * Math.cos( t + 0.4 ) * 15,
											( R + r * Math.cos( n * t + 0.4 ) ) * Math.sin( t + 0.4 ) * 15,
											( r * Math.sin( n * t + 0.4 ) * 15 ) );
			}
			
			public void init() {
				this.color = new AjpUserColor( .8f, .9f, .8f, 1.0f );
				this.tLowerBound = -7;
				this.tUpperBound = 7;
				this.step = 0.01;
			}
		});
		
		window.addParameteredCurve( new AjpUserParameteredCurve() {
			public AjpUser3DPoint evaluate( double t ) {
				double R=1.0;
				double r=0.2;
				double n=17.0/2;
				return new AjpUser3DPoint(  ( R + r * Math.cos( n * t + 0.6 )) * Math.cos( t + 0.6 ) * 15,
											( R + r * Math.cos( n * t + 0.6 ) ) * Math.sin( t + 0.6 ) * 15,
											( r * Math.sin( n * t + 0.6 ) * 15 ) );
			}
			
			public void init() {
				this.color = new AjpUserColor( .9f, .8f, .9f, 1.0f );
				this.tLowerBound = -7;
				this.tUpperBound = 7;
				this.step = 0.01;
			}
		});
		
		// We set the axes' bounds.
		window.setAxesBounds( -10.0, 10.0, -10.0, 10.0, -10.0, 10.0 );
		
		// We set the rotation steps.
		window.setRotationSteps( 0.2, 0.1 );
		
		// We animate the window.
		window.animate();
	}
}
